package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const (
	GroupName  = "rbac.authorization.k8s.io"
	Version    = "v1"
	APIVersion = GroupName + "/" + Version
)

var (
	ClusterRoleBindingTypeMeta = tm("ClusterRoleBinding")
	RoleBindingTypeMeta        = tm("RoleBinding")
)

func tm(kind string) metav1.TypeMeta {
	return metav1.TypeMeta{
		APIVersion: APIVersion,
		Kind:       kind,
	}
}
