package v1

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

const (
	Version    = "v1"
	APIVersion = Version
)

var (
	GroupVersion = schema.GroupVersion{Group: core.GroupName, Version: Version}

	PodTypeMeta                   = tm("Pod")
	ReplicationControllerTypeMeta = tm("ReplicationController")
	ServiceAccountTypeMeta        = tm("ServiceAccount")
	PersistentVolumeClaimTypeMeta = tm("PersistentVolumeClaim")
	PersistentVolumeTypeMeta      = tm("PersistentVolume")
	SecretTypeMeta                = tm("Secret")
	ConfigMapTypeMeta             = tm("ConfigMap")
)

func tm(kind string) metav1.TypeMeta {
	return metav1.TypeMeta{
		APIVersion: APIVersion,
		Kind:       kind,
	}
}
