package core

import (
	"k8s.io/apimachinery/pkg/runtime/schema"
)

const (
	GroupName = ""
)

var (
	NamespaceGK             = gk("Namespace")
	SecretGK                = gk("Secret")
	ConfigMapGK             = gk("ConfigMap")
	ServiceGK               = gk("Service")
	NodeGK                  = gk("Node")
	ServiceAccountGK        = gk("ServiceAccount")
	PersistentVolumeClaimGK = gk("PersistentVolumeClaim")
	PersistentVolumeGK      = gk("PersistentVolume")
)

func gk(kind string) schema.GroupKind {
	return schema.GroupKind{
		Group: GroupName,
		Kind:  kind,
	}
}
