package v2

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const (
	GroupName  = "autoscaling"
	Version    = "v2"
	APIVersion = GroupName + "/" + Version
)

var (
	HorizontalPodAutoscalerTypeMeta = tm("HorizontalPodAutoscaler")
)

func tm(kind string) metav1.TypeMeta {
	return metav1.TypeMeta{
		APIVersion: APIVersion,
		Kind:       kind,
	}
}
