package v1beta3

import (
	notificationapi "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/github.com/fluxcd/notification-controller/api"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const (
	Version    = "v1beta3"
	APIVersion = notificationapi.GroupName + "/" + Version
)

var (
	ProviderTypeMeta = tm("Provider")
	AlertTypeMeta    = tm("Alert")
)

func tm(kind string) metav1.TypeMeta {
	return metav1.TypeMeta{
		APIVersion: APIVersion,
		Kind:       kind,
	}
}
