package watch_graph //nolint:staticcheck

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core"
	storagev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/storage/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectVolumeAttachmentV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[storagev1.VolumeAttachment](obj)
	if err != nil {
		return err
	}

	if o.Spec.Source.PersistentVolumeName != nil {
		vx.setArcToGK(
			core.PersistentVolumeGK,
			*o.Spec.Source.PersistentVolumeName,
			ArcAttrs{},
			ReferenceArcType,
		)
	}

	if o.Spec.Source.InlineVolumeSpec != nil {
		vx.collectPersistentVolumeSpecV1Arcs(o.Spec.Source.InlineVolumeSpec, ReferenceArcType)
	}

	vx.setArcToGK(core.NodeGK, o.Spec.NodeName, ArcAttrs{}, ReferenceArcType)

	return nil
}
