package watch_graph //nolint:staticcheck

import (
	corev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectServiceAccountV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[corev1.ServiceAccount](obj)
	if err != nil {
		return err
	}

	collectEach(o.Secrets, TransitiveReferenceArcType, func(ref *corev1.ObjectReference, arcType ArcType) {
		vx.setArcToSecretNs(ref.Name, ref.Namespace, ArcAttrs{}, arcType)
	})
	collectEach(o.ImagePullSecrets, ReferenceArcType, func(ref *corev1.LocalObjectReference, arcType ArcType) {
		vx.setArcToSecret(ref.Name, ArcAttrs{}, arcType)
	})
	return nil
}
