package watch_graph //nolint:staticcheck

import (
	"maps"

	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectSecretV1(obj *unstructured.Unstructured) *Error {
	// Erase the contents of the Secret in vertex data.
	o := maps.Clone(obj.Object)
	delete(o, "data")
	vx.vd.Object = o

	return vx.collectHelmReleaseFromSecret(obj)
}
