package watch_graph //nolint:staticcheck

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core"
	corev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core/v1"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/storage"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectPersistentVolumeV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[corev1.PersistentVolume](obj)
	if err != nil {
		return err
	}
	vx.collectPersistentVolumeSpecV1Arcs(&o.Spec, ReferenceArcType)
	return nil
}

func (vx *wgObject2vertex) collectPersistentVolumeSpecV1Arcs(spec *corev1.PersistentVolumeSpec, arcType ArcType) {
	if spec.ISCSI != nil {
		if ref := spec.ISCSI.SecretRef; ref != nil {
			vx.setArcToSecretNs(ref.Name, ref.Namespace, ArcAttrs{}, arcType)
		}
	} else if spec.CSI != nil {
		if ref := spec.CSI.NodeStageSecretRef; ref != nil {
			vx.setArcToSecretNs(ref.Name, ref.Namespace, ArcAttrs{}, arcType)
		}
		if ref := spec.CSI.NodePublishSecretRef; ref != nil {
			vx.setArcToSecretNs(ref.Name, ref.Namespace, ArcAttrs{}, arcType)
		}
		if ref := spec.CSI.ControllerExpandSecretRef; ref != nil {
			vx.setArcToSecretNs(ref.Name, ref.Namespace, ArcAttrs{}, arcType)
		}
		if ref := spec.CSI.NodeExpandSecretRef; ref != nil {
			vx.setArcToSecretNs(ref.Name, ref.Namespace, ArcAttrs{}, arcType)
		}
	}
	if spec.ClaimRef != nil {
		vx.setArcToGKNs(
			core.PersistentVolumeClaimGK,
			spec.ClaimRef.Name,
			spec.ClaimRef.Namespace,
			ArcAttrs{},
			arcType,
		)
	}
	if spec.StorageClassName != "" {
		vx.setArcToGK(
			storage.StorageClassGK,
			spec.StorageClassName,
			ArcAttrs{},
			arcType,
		)
	}
	if spec.VolumeAttributesClassName != nil {
		vx.setArcToGK(
			storage.VolumeAttributesClassGK,
			*spec.VolumeAttributesClassName,
			ArcAttrs{},
			arcType,
		)
	}
}
