package watch_graph //nolint:staticcheck

import (
	gatewayapiv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/sigs.k8s.io/gateway-api/apis/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectGatewayHTTPRouteV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[gatewayapiv1.HTTPRoute](obj)
	if err != nil {
		return err
	}

	collectEach(o.Spec.ParentRefs, ReferenceArcType, vx.collectGatewayParentRefV1Arcs)

	collectEach(o.Spec.Rules, ReferenceArcType, func(t *gatewayapiv1.HTTPRouteRule, arcType ArcType) {
		collectEach(t.Filters, ReferenceArcType, vx.collectGatewayHTTPRouteFilterV1Arcs)
		collectEach(t.BackendRefs, ReferenceArcType, func(t *gatewayapiv1.HTTPBackendRef, arcType ArcType) {
			vx.collectGatewayBackendObjRefV1Arcs(&t.BackendObjectReference, arcType)
		})
	})

	return nil
}
