package watch_graph //nolint:staticcheck

import (
	gatewayapiv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/sigs.k8s.io/gateway-api/apis/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectGatewayGRPCRouteV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[gatewayapiv1.GRPCRoute](obj)
	if err != nil {
		return err
	}

	collectEach(o.Spec.ParentRefs, ReferenceArcType, vx.collectGatewayParentRefV1Arcs)

	collectEach(o.Spec.Rules, ReferenceArcType, func(t *gatewayapiv1.GRPCRouteRule, arcType ArcType) {
		collectEach(t.Filters, ReferenceArcType, vx.collectGatewayGRPCRouteFilterV1Arcs)
		collectEach(t.BackendRefs, ReferenceArcType, func(t *gatewayapiv1.GRPCBackendRef, arcType ArcType) {
			vx.collectGatewayBackendObjRefV1Arcs(&t.BackendObjectReference, arcType)
			collectEach(t.Filters, ReferenceArcType, vx.collectGatewayGRPCRouteFilterV1Arcs)
		})
	})

	return nil
}
