package watch_graph //nolint:staticcheck

import (
	"fmt"

	sourceapi "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/github.com/fluxcd/source-controller/api"
	sourcev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/github.com/fluxcd/source-controller/api/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

func (vx *wgObject2vertex) collectFluxCDSourceControllerHelmChartV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[sourcev1.HelmChart](obj)
	if err != nil {
		return err
	}

	func() {
		group := sourceapi.GroupName
		if v := o.Spec.SourceRef.APIVersion; v != "" {
			gv, err := schema.ParseGroupVersion(v)
			if err != nil {
				vx.appendObjectProcessingWarning(fmt.Sprintf("unable to parse FluxCD Helm Chart sourceRef.apiVersion %q: %v", o.Spec.SourceRef.APIVersion, err))
				return
			}
			group = gv.Group
		}

		vx.setArcTo(
			group,
			o.Spec.SourceRef.Kind,
			o.Spec.SourceRef.Name,
			"",
			ArcAttrs{},
			ReferenceArcType,
		)
	}()

	if o.Spec.Verify != nil && o.Spec.Verify.SecretRef != nil {
		vx.setArcToSecret(o.Spec.Verify.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	return nil
}
