package watch_graph //nolint:staticcheck

import (
	sourceapi "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/github.com/fluxcd/source-controller/api"
	sourcev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/github.com/fluxcd/source-controller/api/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectFluxCDSourceControllerGitRepositoryV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[sourcev1.GitRepository](obj)
	if err != nil {
		return err
	}

	if o.Spec.SecretRef != nil {
		vx.setArcToSecret(o.Spec.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.Verification != nil {
		vx.setArcToSecret(o.Spec.Verification.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.ProxySecretRef != nil {
		vx.setArcToSecret(o.Spec.ProxySecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	collectEach(o.Spec.Include, ReferenceArcType, func(t *sourcev1.GitRepositoryInclude, arcType ArcType) {
		vx.setArcToGK(sourceapi.GitRepositoryGK, t.GitRepositoryRef.Name, ArcAttrs{}, arcType)
	})

	return nil
}
