package watch_graph //nolint:staticcheck

import (
	notificationapi "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/github.com/fluxcd/notification-controller/api"
	notificationv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/github.com/fluxcd/notification-controller/api/v1"
	notificationv1beta3 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/github.com/fluxcd/notification-controller/api/v1beta3"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

func (vx *wgObject2vertex) collectFluxCDNotificationControllerAlertV1Beta3(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[notificationv1beta3.Alert](obj)
	if err != nil {
		return err
	}

	vx.setArcToGK(notificationapi.ProviderGK, o.Spec.ProviderRef.Name, ArcAttrs{}, ReferenceArcType)

	collectEach(o.Spec.EventSources, ReferenceArcType, func(t *notificationv1.CrossNamespaceObjectReference, arcType ArcType) {
		group := notificationapi.GroupName
		if v := t.APIVersion; v != "" {
			gv, err := schema.ParseGroupVersion(t.APIVersion)
			if err != nil {
				vx.appendObjectProcessingWarning(err.Error())
				return
			}
			group = gv.Group
		}

		vx.setArcTo(group, t.Kind, t.Name, t.Namespace, ArcAttrs{}, arcType)
	})

	return nil
}
