package watch_graph //nolint:staticcheck

import (
	appsv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/apps/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectDaemonSetV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[appsv1.DaemonSet](obj)
	if err != nil {
		return err
	}

	// DaemonSet transitively references things in the Pod's spec. Hence, use transitive ref type.
	vx.collectPodSpecV1Arcs(&o.Spec.Template.Spec, TransitiveReferenceArcType)

	return nil
}
