package watch_graph //nolint:staticcheck

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/storage"
	storagev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/storage/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectCSIStorageCapacityV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[storagev1.CSIStorageCapacity](obj)
	if err != nil {
		return err
	}

	vx.setArcToGK(storage.StorageClassGK, o.StorageClassName, ArcAttrs{}, ReferenceArcType)
	return nil
}
