package watch_graph //nolint:staticcheck

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core"
	corev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core/v1"
)

func (vx *wgObject2vertex) collectPodSpecV1Arcs(s *corev1.PodSpec, arcType ArcType) {
	collectEach(s.Volumes, arcType, vx.collectVolumeV1Arcs)
	collectEach(s.InitContainers, arcType, vx.collectContainerV1Arcs)
	collectEach(s.Containers, arcType, vx.collectContainerV1Arcs)
	collectEach(s.EphemeralContainers, arcType, vx.collectEphemeralContainerV1Arcs)

	if s.ServiceAccountName != "" {
		vx.setArcToGK(core.ServiceAccountGK, s.ServiceAccountName, ArcAttrs{}, arcType)
	}
	if s.NodeName != "" {
		vx.setArcToGK(core.NodeGK, s.NodeName, ArcAttrs{}, arcType)
	}

	collectEach(s.ImagePullSecrets, arcType, func(r *corev1.LocalObjectReference, arcType ArcType) {
		vx.setArcToSecret(r.Name, ArcAttrs{}, arcType)
	})

	if s.PriorityClassName != "" {
		vx.setArcToGK(priorityClassGK, s.PriorityClassName, ArcAttrs{}, arcType)
	}

	if s.RuntimeClassName != nil && *s.RuntimeClassName != "" {
		vx.setArcToGK(runtimeClassGK, *s.RuntimeClassName, ArcAttrs{}, arcType)
	}

	collectEach(s.ResourceClaims, arcType, func(c *corev1.PodResourceClaim, arcType ArcType) {
		switch {
		case c.ResourceClaimName != nil:
			vx.setArcToGK(resourceClaimGK, *c.ResourceClaimName, ArcAttrs{}, arcType)
		case c.ResourceClaimTemplateName != nil:
			vx.setArcToGK(resourceClaimTemplateGK, *c.ResourceClaimName, ArcAttrs{}, arcType)
		}
	})
}
