package watch_graph //nolint:staticcheck

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core"
	corev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core/v1"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/storage"
	"k8s.io/utils/ptr"
)

func (vx *wgObject2vertex) collectPersistentVolumeClaimV1Arcs(c *corev1.PersistentVolumeClaim, arcType ArcType) {
	vx.collectPersistentVolumeClaimSpecV1Arcs(&c.Spec, arcType)
}

func (vx *wgObject2vertex) collectPersistentVolumeClaimSpecV1Arcs(spec *corev1.PersistentVolumeClaimSpec, arcType ArcType) {
	if spec.VolumeName != "" {
		vx.setArcToGK(core.PersistentVolumeGK, spec.VolumeName, ArcAttrs{}, arcType)
	}
	if spec.StorageClassName != nil {
		vx.setArcToGK(storage.StorageClassGK, *spec.StorageClassName, ArcAttrs{}, arcType)
	}
	if spec.DataSource != nil {
		vx.setArcTo(
			ptr.Deref(spec.DataSource.APIGroup, ""),
			spec.DataSource.Kind,
			spec.DataSource.Name,
			"",
			ArcAttrs{},
			arcType,
		)
	}
	if spec.DataSourceRef != nil {
		vx.setArcTo(
			ptr.Deref(spec.DataSourceRef.APIGroup, ""),
			spec.DataSourceRef.Kind,
			spec.DataSourceRef.Name,
			ptr.Deref(spec.DataSourceRef.Namespace, ""),
			ArcAttrs{},
			arcType,
		)
	}
	if spec.VolumeAttributesClassName != nil {
		vx.setArcToGK(storage.VolumeAttributesClassGK, *spec.VolumeAttributesClassName, ArcAttrs{}, arcType)
	}
}
