package watch_graph //nolint:staticcheck

import (
	gatewayapis "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/sigs.k8s.io/gateway-api/apis"
	gatewayapiv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/sigs.k8s.io/gateway-api/apis/v1"
	"k8s.io/utils/ptr"
)

func (vx *wgObject2vertex) collectGatewayBackendObjRefV1Arcs(r *gatewayapiv1.BackendObjectReference, arcType ArcType) {
	vx.setArcTo(
		string(ptr.Deref(r.Group, "")),
		string(ptr.Deref(r.Kind, "Service")),
		string(r.Name),
		string(ptr.Deref(r.Namespace, "")),
		ArcAttrs{},
		arcType,
	)
}

func (vx *wgObject2vertex) collectGatewaySecretRefV1Arcs(r *gatewayapiv1.SecretObjectReference, arcType ArcType) {
	vx.setArcTo(
		string(ptr.Deref(r.Group, "")),
		string(ptr.Deref(r.Kind, "Secret")),
		string(r.Name),
		string(ptr.Deref(r.Namespace, "")),
		ArcAttrs{},
		arcType,
	)
}

func (vx *wgObject2vertex) collectGatewayParentRefV1Arcs(r *gatewayapiv1.ParentReference, arcType ArcType) {
	vx.setArcTo(
		string(ptr.Deref(r.Group, gatewayapis.GroupName)),
		string(ptr.Deref(r.Kind, "")),
		string(r.Name),
		string(ptr.Deref(r.Namespace, "")),
		ArcAttrs{},
		arcType,
	)
}

func (vx *wgObject2vertex) collectGatewayObjectRefV1Arcs(r *gatewayapiv1.ObjectReference, arcType ArcType) {
	vx.setArcTo(
		string(r.Group),
		string(r.Kind),
		string(r.Name),
		string(ptr.Deref(r.Namespace, "")),
		ArcAttrs{},
		arcType,
	)
}

func (vx *wgObject2vertex) collectGatewayLocalObjectRefV1Arcs(r *gatewayapiv1.LocalObjectReference, arcType ArcType) {
	vx.setArcTo(
		string(r.Group),
		string(r.Kind),
		string(r.Name),
		"",
		ArcAttrs{},
		arcType,
	)
}

func (vx *wgObject2vertex) collectGatewayParametersRefV1Arcs(r *gatewayapiv1.ParametersReference, arcType ArcType) {
	vx.setArcTo(
		string(r.Group),
		string(r.Kind),
		r.Name,
		string(ptr.Deref(r.Namespace, "")),
		ArcAttrs{},
		arcType,
	)
}
func (vx *wgObject2vertex) collectGatewayLocalParametersRefV1Arcs(r *gatewayapiv1.LocalParametersReference, arcType ArcType) {
	vx.setArcTo(
		string(r.Group),
		string(r.Kind),
		r.Name,
		"",
		ArcAttrs{},
		arcType,
	)
}
