package watch_graph //nolint:staticcheck

import (
	corev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/k8s.io/api/core/v1"
)

func (vx *wgObject2vertex) collectEnvVarV1Arcs(v *corev1.EnvVar, arcType ArcType) {
	if v.ValueFrom == nil {
		return
	}
	if v.ValueFrom.ConfigMapKeyRef != nil {
		vx.setArcToConfigMap(v.ValueFrom.ConfigMapKeyRef.Name, ArcAttrs{}, arcType)
	}
	if v.ValueFrom.SecretKeyRef != nil {
		vx.setArcToSecret(v.ValueFrom.SecretKeyRef.Name, ArcAttrs{}, arcType)
	}
}
