package agent

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kas2agentk_tunnel"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kas2agentk_tunnel/router"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modagentk"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tunnel/rpc"
)

type Factory struct {
	Registry *router.Registry
}

func (f *Factory) IsProducingLeaderModules() bool {
	return false
}

func (f *Factory) New(config *modagentk.Config) (modagentk.Module, error) {
	rpc.RegisterReverseTunnelServer(config.APIServer, &server{
		registry: f.Registry,
	})
	return nil, nil
}

func (f *Factory) Name() string {
	return kas2agentk_tunnel.ModuleName
}
