package agent

import (
	"context"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/agent2kas_tunnel"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tunnel/tunclient"
)

type Module[CM any] struct {
	ConnManager *tunclient.ConnectionManager
}

func (m *Module[CM]) Run(ctx context.Context, _ <-chan CM) error {
	m.ConnManager.Run(ctx)
	return nil
}

func (m *Module[CM]) DefaultAndValidateConfiguration(_ CM) error {
	return nil
}

func (m *Module[CM]) Name() string {
	return agent2kas_tunnel.ModuleName
}
