package api

import (
	"context"
	"net/http"
	"net/url"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/gitlab"
)

const (
	ModuleRequestAPIPath = "/api/v4/internal/kubernetes/modules/"
)

func MakeModuleRequest(ctx context.Context, client gitlab.ClientInterface, agentTokenWithType api.AgentTokenWithType,
	moduleName, method, urlPath string, query url.Values, header http.Header, body []byte,
	opts ...gitlab.DoOption) (*http.Response, error) {
	var resp *http.Response
	err := client.Do(ctx,
		joinOpts(opts,
			gitlab.WithMethod(method),
			gitlab.WithPath(ModuleRequestAPIPath+url.PathEscape(moduleName)+urlPath),
			gitlab.WithQuery(query),
			gitlab.WithHeader(header),
			gitlab.WithAgentTokenAndType(agentTokenWithType),
			gitlab.WithJWT(true),
			gitlab.WithRequestBodyBytes(body, ""),
			gitlab.WithResponseHandler(gitlab.NakedResponseHandler(&resp)),
		)...,
	)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
