package api

import (
	"context"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/gitlab"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/featureflag"
)

const (
	AllowedAgentsAPIPath = "/api/v4/job/allowed_agents"
)

type AllowedAgentsForJob struct {
	Response     *AllowedAgentsForJobAPIResponse
	FeatureFlags featureflag.Set
}

func GetAllowedAgentsForJob(ctx context.Context, client gitlab.ClientInterface, jobToken string, opts ...gitlab.DoOption) (*AllowedAgentsForJob, error) {
	aa := &AllowedAgentsForJobAPIResponse{}
	var ffs featureflag.Set
	err := client.Do(ctx,
		joinOpts(opts,
			gitlab.WithPath(AllowedAgentsAPIPath),
			gitlab.WithJobToken(jobToken),
			gitlab.WithResponseHandler(gitlab.ProtoJSONResponseHandler(aa)),
			gitlab.WithFeatureFlags(&ffs),
		)...,
	)
	if err != nil {
		return nil, err
	}
	return &AllowedAgentsForJob{
		Response:     aa,
		FeatureFlags: ffs,
	}, nil
}
