package api

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
)

func (a *GetAgentkInfoResponse) ToAPIAgentInfo() *api.AgentkInfo {
	return &api.AgentkInfo{
		Key: api.AgentKey{
			ID:   a.AgentId,
			Type: api.AgentTypeKubernetes,
		},
		ProjectID:     a.ProjectId,
		Name:          a.AgentName,
		GitalyInfo:    a.GitalyInfo,
		Repository:    a.GitalyRepository.ToGitalyRepository(),
		DefaultBranch: a.DefaultBranch,
	}
}

func (a *GetAgentwInfoResponse) ToAPIAgentInfo() *api.AgentwInfo {
	return &api.AgentwInfo{
		Key: api.AgentKey{
			ID:   a.WorkspaceId,
			Type: api.AgentTypeWorkspace,
		},
	}
}

func (p *GetRepositoryInfoResponse) ToAPIProjectInfo() *api.ProjectInfo {
	return &api.ProjectInfo{
		ProjectID:     p.ProjectId,
		GitalyInfo:    p.GitalyInfo,
		Repository:    p.GitalyRepository.ToGitalyRepository(),
		DefaultBranch: p.DefaultBranch,
	}
}
