package agent

import (
	"strings"
)

const (
	envVarTelemetryPrefix = "GITLAB_AGENT_TELEMETRY_"
)

func CollectExtraTelemetryData(environ []string) map[string]string {
	out := make(map[string]string)
	for _, env := range environ {
		key, value, found := strings.Cut(env, "=")
		if !found {
			continue
		}
		if telemetryKey, found := strings.CutPrefix(key, envVarTelemetryPrefix); found {
			if telemetryKey != "" {
				out[telemetryKey] = value
			}
		}
	}
	return out
}
