package grpctool

import (
	"context"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
	"google.golang.org/grpc/credentials"
)

const (
	MetadataAuthorization = "authorization"
	MetadataAgentType     = "gitlab-agent-type"
)

func NewTokenCredentials(token api.AgentToken, agentType api.AgentType, insecure bool) credentials.PerRPCCredentials {
	return &tokenCredentials{
		metadata: map[string]string{
			MetadataAuthorization: "Bearer " + string(token),
			MetadataAgentType:     agentType.String(),
		},
		insecure: insecure,
	}
}

type tokenCredentials struct {
	metadata map[string]string
	insecure bool
}

func (t *tokenCredentials) GetRequestMetadata(ctx context.Context, uri ...string) (map[string]string, error) {
	return t.metadata, nil
}

func (t *tokenCredentials) RequireTransportSecurity() bool {
	return !t.insecure
}
