package modagentk

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modagent"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/agentcfg"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/entity"
	"google.golang.org/grpc"
	"k8s.io/kubectl/pkg/cmd/util"
)

// Config holds configuration for a Module.
type Config struct {
	modagent.Config
	AgentMeta *entity.AgentkMeta
	// K8sUtilFactory provides means to interact with the Kubernetes cluster agentk is running in.
	K8sUtilFactory util.Factory
	// RegisterKASAPI allows to register a gRPC API endpoint that agentk proxies to kas.
	RegisterKASAPI func(*grpc.ServiceDesc)
	// ServiceAccountName is a string defined by default as "gitlab-agent".
	ServiceAccountName string
}

// These are aliases so that parametrised types and these types are the same type, not distinct types.

type Factory = modagent.Factory[*Config, *agentcfg.AgentConfiguration]

type Module = modagent.Module[*agentcfg.AgentConfiguration]
