package watch_graph //nolint:staticcheck

import (
	corev1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectServiceAccountV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[corev1.ServiceAccount](obj)
	if err != nil {
		return err
	}

	collectEach(o.ImagePullSecrets, ReferenceArcType, func(ref *corev1.LocalObjectReference, arcType ArcType) {
		vx.setArcToSecret(ref.Name, ArcAttrs{}, arcType)
	})
	return nil
}
