package watch_graph //nolint:staticcheck

import (
	corev1 "k8s.io/api/core/v1"
)

func (vx *wgObject2vertex) collectPodSpecV1Arcs(s *corev1.PodSpec, arcType ArcType) {
	collectEach(s.Volumes, arcType, vx.collectVolumeV1Arcs)
	collectEach(s.InitContainers, arcType, vx.collectContainerV1Arcs)
	collectEach(s.Containers, arcType, vx.collectContainerV1Arcs)
	collectEach(s.EphemeralContainers, arcType, vx.collectEphemeralContainerV1Arcs)

	if s.ServiceAccountName != "" {
		vx.setArcToGVK(serviceAccountGVK, s.ServiceAccountName, ArcAttrs{}, arcType)
	}
	if s.NodeName != "" {
		vx.setArcToGVK(nodeGVK, s.NodeName, ArcAttrs{}, arcType)
	}

	collectEach(s.ImagePullSecrets, arcType, func(r *corev1.LocalObjectReference, arcType ArcType) {
		vx.setArcToGVK(secretGVK, r.Name, ArcAttrs{}, arcType)
	})

	if s.PriorityClassName != "" {
		vx.setArcToGVK(priorityClassGVK, s.PriorityClassName, ArcAttrs{}, arcType)
	}

	if s.RuntimeClassName != nil && *s.RuntimeClassName != "" {
		vx.setArcToGVK(runtimeClassGVK, *s.RuntimeClassName, ArcAttrs{}, arcType)
	}

	collectEach(s.ResourceClaims, arcType, func(c *corev1.PodResourceClaim, arcType ArcType) {
		switch {
		case c.ResourceClaimName != nil:
			vx.setArcToGVK(resourceClaimV1Beta1GVK, *c.ResourceClaimName, ArcAttrs{}, arcType)
		case c.ResourceClaimTemplateName != nil:
			vx.setArcToGVK(resourceClaimTemplateV1Beta1GVK, *c.ResourceClaimName, ArcAttrs{}, arcType)
		}
	})
}
