package watch_graph //nolint:staticcheck

import (
	corev1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectPersistentVolumeV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[corev1.PersistentVolume](obj)
	if err != nil {
		return err
	}
	vx.collectPersistentVolumeSpecV1Arcs(&o.Spec, ReferenceArcType)
	return nil
}

func (vx *wgObject2vertex) collectPersistentVolumeSpecV1Arcs(spec *corev1.PersistentVolumeSpec, arcType ArcType) {
	if spec.ClaimRef != nil {
		vx.setArcTo(
			persistentVolumeClaimGVK.Group,
			persistentVolumeClaimGVK.Kind,
			spec.ClaimRef.Name,
			spec.ClaimRef.Namespace,
			ArcAttrs{},
			arcType,
		)
	}
	if spec.StorageClassName != "" {
		vx.setArcToGVK(
			storageClassGVK,
			spec.StorageClassName,
			ArcAttrs{},
			arcType,
		)
	}
	if spec.VolumeAttributesClassName != nil {
		vx.setArcToGVK(
			volumeAttributesClassV1Beta1GVK,
			*spec.VolumeAttributesClassName,
			ArcAttrs{},
			arcType,
		)
	}
}
