package watch_graph //nolint:staticcheck

import (
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/utils/ptr"
	gatewayapiv1 "sigs.k8s.io/gateway-api/apis/v1"
)

func (vx *wgObject2vertex) collectGatewayGRPCRouteV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[gatewayapiv1.GRPCRoute](obj)
	if err != nil {
		return err
	}

	collectEach(o.Spec.ParentRefs, ReferenceArcType, vx.collectGatewayParentRefV1Arcs)

	collectEach(o.Spec.Rules, ReferenceArcType, func(t *gatewayapiv1.GRPCRouteRule, arcType ArcType) {
		collectEach(t.BackendRefs, ReferenceArcType, func(t *gatewayapiv1.GRPCBackendRef, arcType ArcType) {
			vx.setArcTo(
				string(ptr.Deref(t.Group, "")),
				string(ptr.Deref(t.Kind, "Service")),
				string(t.Name),
				string(ptr.Deref(t.Namespace, "")),
				ArcAttrs{},
				arcType,
			)
		})
	})

	return nil
}
