package watch_graph //nolint:staticcheck

import (
	"fmt"

	sourcev1 "github.com/fluxcd/source-controller/api/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

func (vx *wgObject2vertex) collectFluxCDSourceControllerHelmChartV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[sourcev1.HelmChart](obj)
	if err != nil {
		return err
	}

	group := sourcev1.GroupVersion.Group
	if v := o.Spec.SourceRef.APIVersion; v != "" {
		gv, err := schema.ParseGroupVersion(v)
		if err != nil {
			vx.appendObjectProcessingWarning(fmt.Sprintf("unable to parse FluxCD Helm Chart sourceRef.apiVersion %q, using default %q as group instead: %v", o.Spec.SourceRef.APIVersion, group, err))
			return nil
		}
		group = gv.Group
	}

	vx.setArcTo(
		group,
		o.Spec.SourceRef.Kind,
		o.Spec.SourceRef.Name,
		"",
		ArcAttrs{},
		ReferenceArcType,
	)

	if o.Spec.Verify != nil && o.Spec.Verify.SecretRef != nil {
		vx.setArcToSecret(o.Spec.Verify.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	return nil
}
