package watch_graph //nolint:staticcheck

import (
	appsv1 "k8s.io/api/apps/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectDeploymentV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[appsv1.Deployment](obj)
	if err != nil {
		return err
	}

	// Deployment transitively references things in the Pod's spec. Hence, use transitive ref type.
	vx.collectPodSpecV1Arcs(&o.Spec.Template.Spec, TransitiveReferenceArcType)

	return nil
}
