package watch_graph //nolint:staticcheck

import (
	storagev1 "k8s.io/api/storage/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectCSIStorageCapacityV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[storagev1.CSIStorageCapacity](obj)
	if err != nil {
		return err
	}

	vx.setArcToGVK(storageClassGVK, o.StorageClassName, ArcAttrs{}, ReferenceArcType)
	return nil
}
