package watch_graph //nolint:staticcheck
import (
	"fmt"
)

type ErrorCode byte

const (
	_ ErrorCode = iota
	InvalidArgument
	Unavailable
	InternalError
)

func (c ErrorCode) String() string {
	switch c {
	case InvalidArgument:
		return "InvalidArgument"
	case Unavailable:
		return "Unavailable"
	case InternalError:
		return "InternalError"
	default:
		return "Unknown"
	}
}

type Error struct {
	Message string
	Code    ErrorCode
}

// Don't want to make it an 'error' to avoid accidental confusion, so String() instead of Error().

func (e *Error) String() string {
	return fmt.Sprintf("%s: %s", e.Code, e.Message)
}
