package agent

import (
	"context"
	"testing"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/agent_registrar/rpc"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/testing/mock_agent_registrar"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/testing/testhelpers"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/testing/testlogger"
	"go.uber.org/mock/gomock"
	"google.golang.org/grpc"
)

func TestModule_Run(t *testing.T) {
	ctx, cancel := context.WithCancel(context.Background())
	defer cancel()

	ctrl := gomock.NewController(t)
	client := mock_agent_registrar.NewMockAgentRegistrarClient(ctrl)
	gomock.InOrder(
		client.EXPECT().
			Register(gomock.Any(), gomock.Any(), gomock.Any()).
			DoAndReturn(func(ctx context.Context, request *rpc.RegisterRequest, opts ...grpc.CallOption) (*rpc.RegisterResponse, error) {
				cancel()
				return &rpc.RegisterResponse{}, nil
			}),
		client.EXPECT().Unregister(gomock.Any(), gomock.Any()),
	)

	m := &Module[int32]{
		Log:        testlogger.New(t),
		PollConfig: testhelpers.NewPollConfig(0),
		Client:     client,
		RegisterRequest: func() *rpc.RegisterRequest {
			return &rpc.RegisterRequest{}
		},
		UnregisterRequest: func() *rpc.UnregisterRequest {
			return &rpc.UnregisterRequest{}
		},
	}
	_ = m.Run(ctx, nil)
}
