package api

import (
	"context"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/gitlab"
)

const (
	WorkspacesServerConfigAPIPath = "/api/v4/internal/agents/agentw/server_config"
)

func GetWorkspacesServerConfig(ctx context.Context, client gitlab.ClientInterface, opts ...gitlab.DoOption) (*GetWorkspacesServerConfigResponse, error) {
	response := &GetWorkspacesServerConfigResponse{}
	err := client.Do(ctx,
		joinOpts(opts,
			gitlab.WithPath(WorkspacesServerConfigAPIPath),
			gitlab.WithResponseHandler(gitlab.ProtoJSONResponseHandler(response)),
			gitlab.WithJWT(true),
		)...,
	)
	if err != nil {
		return nil, err
	}
	return response, nil
}
