package autoflow

import (
	"log/slog"
	"os"

	"github.com/spf13/cobra"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/cmd/autoflow/commands/run-local"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/logz"
)

func NewCommand() *cobra.Command {
	lockedWriter := &logz.LockedWriter{
		Writer: os.Stderr,
	}
	log := slog.New(slog.NewTextHandler(lockedWriter, &slog.HandlerOptions{Level: slog.LevelDebug}))
	c := &cobra.Command{
		Use:          "autoflow",
		Short:        "GitLab AutoFlow command line utility",
		Args:         cobra.NoArgs,
		SilenceUsage: true,
	}
	c.AddCommand(runlocal.NewCommand(log))
	return c
}
