package agent

// terminationTrackerKey is used as a key within terminationTracker
// to uniquely identify a combination of workspace name and namespace that must be tracked
type terminationTrackerKey struct {
	name      string
	namespace string
}

type terminationDetails struct {
	progress TerminationProgress

	// isReconciled indicates whether progress has been reconciled with Rails or not
	isReconciled bool
}

// terminationTracker is a set to track workspaces that exist in Terminating/Terminated state
type terminationTracker map[terminationTrackerKey]terminationDetails

func newTerminationTracker() terminationTracker {
	return make(map[terminationTrackerKey]terminationDetails)
}

func (t terminationTracker) updateOrSet(name string, namespace string, progress TerminationProgress) {
	key := terminationTrackerKey{
		name:      name,
		namespace: namespace,
	}
	existingDetails, ok := t[key]
	// if there's an existing tracker and the progress is what we
	// expect, then we can consider it reconciled
	isReconciled := ok && existingDetails.progress == progress
	t[key] = terminationDetails{
		progress:     progress,
		isReconciled: isReconciled,
	}
}

func (t terminationTracker) delete(name string, namespace string) {
	key := terminationTrackerKey{
		name:      name,
		namespace: namespace,
	}
	delete(t, key)
}
