package modserver

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modshared"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/featureflag"
)

// RPCAPI defines the gRPC-specific API for server modules to use.
type RPCAPI interface {
	modshared.RPCAPI

	// IsEnabled returns if the given feature flag is enabled
	IsEnabled(ff *featureflag.FeatureFlag) bool
	// IsDisabled returns if the given feature flag is disabled
	IsDisabled(ff *featureflag.FeatureFlag) bool
}
