package watch_graph //nolint:staticcheck

import (
	"maps"

	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) object2vertexData(obj *unstructured.Unstructured) VertexData {
	o := *obj
	if o.GetObjectKind().GroupVersionKind() == secretGVK {
		// Erase the contents of Secrets.
		o.Object = maps.Clone(o.Object)
		delete(o.Object, "data")
	}
	return VertexData{
		Object:   o.Object,
		JSONPath: vx.info.object.JSONPath,
	}
}
