package watch_graph //nolint:staticcheck

import (
	corev1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectReplicationControllerV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[corev1.ReplicationController](obj)
	if err != nil {
		return err
	}

	// ReplicationController transitively references things in the Pod's spec. Hence, use transitive ref type.
	vx.collectPodSpecV1Arcs(&o.Spec.Template.Spec, TransitiveReferenceArcType)

	return nil
}
