package watch_graph //nolint:staticcheck

import (
	"k8s.io/utils/ptr"
	gatewayapiv1 "sigs.k8s.io/gateway-api/apis/v1"
)

func (vx *wgObject2vertex) collectGatewayParentRefV1Arcs(o *gatewayapiv1.ParentReference, arcType ArcType) {
	vx.setArcTo(
		string(ptr.Deref(o.Group, "gateway.networking.k8s.io")),
		string(ptr.Deref(o.Kind, "")),
		string(o.Name),
		string(ptr.Deref(o.Namespace, "")),
		ArcAttrs{},
		arcType,
	)
}
