package watch_graph //nolint:staticcheck

import (
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/utils/ptr"
	gatewayapiv1 "sigs.k8s.io/gateway-api/apis/v1"
)

func (vx *wgObject2vertex) collectGatewayV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[gatewayapiv1.Gateway](obj)
	if err != nil {
		return err
	}

	if o.Spec.GatewayClassName != "" {
		vx.setArcToGVK(gatewayClassGVK, string(o.Spec.GatewayClassName), ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.BackendTLS != nil && o.Spec.BackendTLS.ClientCertificateRef != nil && o.Spec.BackendTLS.ClientCertificateRef.Name != "" {
		vx.setArcTo(
			string(ptr.Deref(o.Spec.BackendTLS.ClientCertificateRef.Group, "")),
			string(ptr.Deref(o.Spec.BackendTLS.ClientCertificateRef.Kind, "Secret")),
			string(o.Spec.BackendTLS.ClientCertificateRef.Name),
			string(ptr.Deref(o.Spec.BackendTLS.ClientCertificateRef.Namespace, "")),
			ArcAttrs{},
			ReferenceArcType,
		)
	}

	return nil
}
