package watch_graph //nolint:staticcheck

import (
	sourcev1 "github.com/fluxcd/source-controller/api/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectFluxCDSourceControllerHelmRepositoryV1Arcs(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[sourcev1.HelmRepository](obj)
	if err != nil {
		return err
	}

	if o.Spec.SecretRef != nil {
		vx.setArcToSecret(o.Spec.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.CertSecretRef != nil {
		vx.setArcToSecret(o.Spec.CertSecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	return nil
}
