package watch_graph //nolint:staticcheck

import (
	eventsv1 "k8s.io/api/events/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

func (vx *wgObject2vertex) collectEventV1Arcs(obj *unstructured.Unstructured) *Error {
	o, errX := unstructuredToTyped[eventsv1.Event](obj)
	if errX != nil {
		return errX
	}

	gv, err := schema.ParseGroupVersion(o.Regarding.APIVersion)
	if err != nil {
		vx.appendObjectProcessingWarning(err.Error())
	} else {
		vx.setArcTo(gv.Group, o.Regarding.Kind, o.Regarding.Name, o.Regarding.Namespace, ArcAttrs{}, ReferenceArcType)
	}

	if o.Related != nil {
		gv, err = schema.ParseGroupVersion(o.Related.APIVersion)
		if err != nil {
			vx.appendObjectProcessingWarning(err.Error())
		} else {
			vx.setArcTo(gv.Group, o.Related.Kind, o.Related.Name, o.Related.Namespace, ArcAttrs{}, ReferenceArcType)
		}
	}

	return nil
}
