package agent

import (
	"cloud.google.com/go/profiler"
	"google.golang.org/api/option"
)

type ProfilerCfg struct {
	Enabled         bool
	ProjectID       string
	CredentialsFile string
	DebugLogging    bool
}

type ProfilerRunner interface {
	Start(cfg ProfilerCfg) error
}

type GoogleProfilerRunner struct {
	Service string
	Version string
}

func (r *GoogleProfilerRunner) Start(cfg ProfilerCfg) error {
	config := profiler.Config{
		Service:        r.Service,
		ServiceVersion: r.Version,
		DebugLogging:   cfg.DebugLogging,
		MutexProfiling: true, // like in LabKit
		ProjectID:      cfg.ProjectID,
	}
	var opts []option.ClientOption
	if cfg.CredentialsFile != "" {
		opts = append(opts, option.WithCredentialsFile(cfg.CredentialsFile))
	}
	return profiler.Start(config, opts...)
}
