package api

import (
	"context"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/gitlab"
)

const (
	OpenIDConfigurationAPIPath = "/.well-known/openid-configuration"
)

func GetOpenIDConfiguration(ctx context.Context, client gitlab.ClientInterface, opts ...gitlab.DoOption) (*GetOpenIDConfigurationResponse, error) {
	response := &GetOpenIDConfigurationResponse{}
	err := client.Do(ctx,
		joinOpts(opts,
			gitlab.WithPath(OpenIDConfigurationAPIPath),
			gitlab.WithResponseHandler(gitlab.ProtoJSONResponseHandler(response)),
			gitlab.WithJWT(true),
		)...,
	)
	if err != nil {
		return nil, err
	}
	return response, nil
}
