# Protocol Documentation
<a name="top"></a>

## Table of Contents

- [pkg/agentcfg/agentcfg.proto](#pkg_agentcfg_agentcfg-proto)
    - [AgentConfiguration](#gitlab-agent-agentcfg-AgentConfiguration)
    - [CiAccessAsAgentCF](#gitlab-agent-agentcfg-CiAccessAsAgentCF)
    - [CiAccessAsCF](#gitlab-agent-agentcfg-CiAccessAsCF)
    - [CiAccessAsCiJobCF](#gitlab-agent-agentcfg-CiAccessAsCiJobCF)
    - [CiAccessAsImpersonateCF](#gitlab-agent-agentcfg-CiAccessAsImpersonateCF)
    - [CiAccessCF](#gitlab-agent-agentcfg-CiAccessCF)
    - [CiAccessGroupCF](#gitlab-agent-agentcfg-CiAccessGroupCF)
    - [CiAccessInstanceCF](#gitlab-agent-agentcfg-CiAccessInstanceCF)
    - [CiAccessProjectCF](#gitlab-agent-agentcfg-CiAccessProjectCF)
    - [ConfigurationFile](#gitlab-agent-agentcfg-ConfigurationFile)
    - [ContainerScanningCF](#gitlab-agent-agentcfg-ContainerScanningCF)
    - [ContainerScanningFilter](#gitlab-agent-agentcfg-ContainerScanningFilter)
    - [ExtraKeyValCF](#gitlab-agent-agentcfg-ExtraKeyValCF)
    - [FluxCF](#gitlab-agent-agentcfg-FluxCF)
    - [GitLabWorkspacesProxy](#gitlab-agent-agentcfg-GitLabWorkspacesProxy)
    - [GoogleProfilerCF](#gitlab-agent-agentcfg-GoogleProfilerCF)
    - [LoggingCF](#gitlab-agent-agentcfg-LoggingCF)
    - [ObservabilityCF](#gitlab-agent-agentcfg-ObservabilityCF)
    - [RemoteDevelopmentCF](#gitlab-agent-agentcfg-RemoteDevelopmentCF)
    - [RemoteDevelopmentCF.AnnotationsEntry](#gitlab-agent-agentcfg-RemoteDevelopmentCF-AnnotationsEntry)
    - [RemoteDevelopmentCF.LabelsEntry](#gitlab-agent-agentcfg-RemoteDevelopmentCF-LabelsEntry)
    - [Resource](#gitlab-agent-agentcfg-Resource)
    - [ResourceManagementCF](#gitlab-agent-agentcfg-ResourceManagementCF)
    - [ResourceRequirements](#gitlab-agent-agentcfg-ResourceRequirements)
    - [TrivyK8sWrapperImage](#gitlab-agent-agentcfg-TrivyK8sWrapperImage)
    - [UserAccessAsAgentCF](#gitlab-agent-agentcfg-UserAccessAsAgentCF)
    - [UserAccessAsCF](#gitlab-agent-agentcfg-UserAccessAsCF)
    - [UserAccessAsUserCF](#gitlab-agent-agentcfg-UserAccessAsUserCF)
    - [UserAccessCF](#gitlab-agent-agentcfg-UserAccessCF)
    - [UserAccessGroupCF](#gitlab-agent-agentcfg-UserAccessGroupCF)
    - [UserAccessInstanceCF](#gitlab-agent-agentcfg-UserAccessInstanceCF)
    - [UserAccessProjectCF](#gitlab-agent-agentcfg-UserAccessProjectCF)
    - [VulnerabilityReport](#gitlab-agent-agentcfg-VulnerabilityReport)
    - [WorkspaceImagePullSecret](#gitlab-agent-agentcfg-WorkspaceImagePullSecret)
    - [WorkspaceNetworkPolicy](#gitlab-agent-agentcfg-WorkspaceNetworkPolicy)
    - [WorkspaceNetworkPolicyEgress](#gitlab-agent-agentcfg-WorkspaceNetworkPolicyEgress)
  
    - [log_level_enum](#gitlab-agent-agentcfg-log_level_enum)
  
- [Scalar Value Types](#scalar-value-types)



<a name="pkg_agentcfg_agentcfg-proto"></a>
<p align="right"><a href="#top">Top</a></p>

## pkg/agentcfg/agentcfg.proto



<a name="gitlab-agent-agentcfg-AgentConfiguration"></a>

### AgentConfiguration
AgentConfiguration represents configuration for agentk.
Note that agentk configuration is not exactly the whole file as the file
may contain bits that are not relevant for the agent. For example, some
additional config for kas.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| observability | [ObservabilityCF](#gitlab-agent-agentcfg-ObservabilityCF) |  |  |
| agent_id | [int64](#int64) |  | GitLab-wide unique id of the agent for the given agent_type. |
| project_id | [int64](#int64) |  | Id of the configuration project. |
| ci_access | [CiAccessCF](#gitlab-agent-agentcfg-CiAccessCF) |  |  |
| container_scanning | [ContainerScanningCF](#gitlab-agent-agentcfg-ContainerScanningCF) |  |  |
| project_path | [string](#string) |  | Path of the configuration project |
| remote_development | [RemoteDevelopmentCF](#gitlab-agent-agentcfg-RemoteDevelopmentCF) |  |  |
| flux | [FluxCF](#gitlab-agent-agentcfg-FluxCF) |  |  |
| gitlab_external_url | [string](#string) |  |  |






<a name="gitlab-agent-agentcfg-CiAccessAsAgentCF"></a>

### CiAccessAsAgentCF







<a name="gitlab-agent-agentcfg-CiAccessAsCF"></a>

### CiAccessAsCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| agent | [CiAccessAsAgentCF](#gitlab-agent-agentcfg-CiAccessAsAgentCF) |  |  |
| impersonate | [CiAccessAsImpersonateCF](#gitlab-agent-agentcfg-CiAccessAsImpersonateCF) |  |  |
| ci_job | [CiAccessAsCiJobCF](#gitlab-agent-agentcfg-CiAccessAsCiJobCF) |  |  |






<a name="gitlab-agent-agentcfg-CiAccessAsCiJobCF"></a>

### CiAccessAsCiJobCF







<a name="gitlab-agent-agentcfg-CiAccessAsImpersonateCF"></a>

### CiAccessAsImpersonateCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| username | [string](#string) |  |  |
| groups | [string](#string) | repeated |  |
| uid | [string](#string) |  |  |
| extra | [ExtraKeyValCF](#gitlab-agent-agentcfg-ExtraKeyValCF) | repeated |  |






<a name="gitlab-agent-agentcfg-CiAccessCF"></a>

### CiAccessCF
https://gitlab.com/gitlab-org/cluster-integration/gitlab-agent/-/blob/master/doc/kubernetes_ci_access.md


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| projects | [CiAccessProjectCF](#gitlab-agent-agentcfg-CiAccessProjectCF) | repeated |  |
| groups | [CiAccessGroupCF](#gitlab-agent-agentcfg-CiAccessGroupCF) | repeated |  |
| instance | [CiAccessInstanceCF](#gitlab-agent-agentcfg-CiAccessInstanceCF) |  | CiAccessOrganizationCF organization = 4 [json_name = &#34;organization&#34;]; |






<a name="gitlab-agent-agentcfg-CiAccessGroupCF"></a>

### CiAccessGroupCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| id | [string](#string) |  |  |
| default_namespace | [string](#string) |  |  |
| access_as | [CiAccessAsCF](#gitlab-agent-agentcfg-CiAccessAsCF) |  |  |
| environments | [string](#string) | repeated |  |
| annotations | [google.protobuf.Struct](#google-protobuf-Struct) |  |  |
| protected_branches_only | [bool](#bool) |  |  |
| resource_management | [ResourceManagementCF](#gitlab-agent-agentcfg-ResourceManagementCF) |  |  |






<a name="gitlab-agent-agentcfg-CiAccessInstanceCF"></a>

### CiAccessInstanceCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| default_namespace | [string](#string) |  |  |
| access_as | [CiAccessAsCF](#gitlab-agent-agentcfg-CiAccessAsCF) |  |  |
| environments | [string](#string) | repeated |  |
| annotations | [google.protobuf.Struct](#google-protobuf-Struct) |  |  |
| protected_branches_only | [bool](#bool) |  |  |
| resource_management | [ResourceManagementCF](#gitlab-agent-agentcfg-ResourceManagementCF) |  |  |






<a name="gitlab-agent-agentcfg-CiAccessProjectCF"></a>

### CiAccessProjectCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| id | [string](#string) |  |  |
| default_namespace | [string](#string) |  |  |
| access_as | [CiAccessAsCF](#gitlab-agent-agentcfg-CiAccessAsCF) |  |  |
| environments | [string](#string) | repeated |  |
| annotations | [google.protobuf.Struct](#google-protobuf-Struct) |  |  |
| protected_branches_only | [bool](#bool) |  |  |
| resource_management | [ResourceManagementCF](#gitlab-agent-agentcfg-ResourceManagementCF) |  |  |






<a name="gitlab-agent-agentcfg-ConfigurationFile"></a>

### ConfigurationFile
ConfigurationFile represents user-facing configuration file.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| observability | [ObservabilityCF](#gitlab-agent-agentcfg-ObservabilityCF) |  | Configuration related to all things observability. This is about the agent itself, not any observability-related features. |
| ci_access | [CiAccessCF](#gitlab-agent-agentcfg-CiAccessCF) |  |  |
| container_scanning | [ContainerScanningCF](#gitlab-agent-agentcfg-ContainerScanningCF) |  |  |
| user_access | [UserAccessCF](#gitlab-agent-agentcfg-UserAccessCF) |  |  |
| remote_development | [RemoteDevelopmentCF](#gitlab-agent-agentcfg-RemoteDevelopmentCF) |  |  |
| flux | [FluxCF](#gitlab-agent-agentcfg-FluxCF) |  |  |






<a name="gitlab-agent-agentcfg-ContainerScanningCF"></a>

### ContainerScanningCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| vulnerability_report | [VulnerabilityReport](#gitlab-agent-agentcfg-VulnerabilityReport) |  |  |
| cadence | [string](#string) |  |  |
| resource_requirements | [ResourceRequirements](#gitlab-agent-agentcfg-ResourceRequirements) |  |  |
| trivy_k8s_wrapper_image | [TrivyK8sWrapperImage](#gitlab-agent-agentcfg-TrivyK8sWrapperImage) |  |  |
| persist_ocs_status | [bool](#bool) | optional |  |
| scanner_timeout | [google.protobuf.Duration](#google-protobuf-Duration) |  |  |
| report_max_size | [uint64](#uint64) |  | The maximum size of the generated Trivy Report, in bytes |
| delete_report_artifact | [bool](#bool) | optional | Determines whether the Trivy Report ConfigMap is deleted after a Vulnerability Scan. Defaults to true |






<a name="gitlab-agent-agentcfg-ContainerScanningFilter"></a>

### ContainerScanningFilter



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| namespaces | [string](#string) | repeated |  |
| resources | [string](#string) | repeated |  |
| containers | [string](#string) | repeated |  |
| kinds | [string](#string) | repeated |  |






<a name="gitlab-agent-agentcfg-ExtraKeyValCF"></a>

### ExtraKeyValCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [string](#string) |  |  |
| val | [string](#string) | repeated | Empty elements are allowed by Kubernetes. |






<a name="gitlab-agent-agentcfg-FluxCF"></a>

### FluxCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| webhook_receiver_url | [string](#string) |  |  |
| enabled | [bool](#bool) | optional |  |






<a name="gitlab-agent-agentcfg-GitLabWorkspacesProxy"></a>

### GitLabWorkspacesProxy
GitLabWorkspacesProxy represents the gitlab workspaces proxy configuration for the remote development module


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| namespace | [string](#string) |  |  |






<a name="gitlab-agent-agentcfg-GoogleProfilerCF"></a>

### GoogleProfilerCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| enabled | [bool](#bool) |  |  |
| project_id | [string](#string) |  |  |
| credentials_file | [string](#string) |  |  |
| debug_logging | [bool](#bool) |  |  |






<a name="gitlab-agent-agentcfg-LoggingCF"></a>

### LoggingCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| level | [log_level_enum](#gitlab-agent-agentcfg-log_level_enum) |  |  |
| grpc_level | [log_level_enum](#gitlab-agent-agentcfg-log_level_enum) | optional | optional to be able to tell when not set and use a different default value. |






<a name="gitlab-agent-agentcfg-ObservabilityCF"></a>

### ObservabilityCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| logging | [LoggingCF](#gitlab-agent-agentcfg-LoggingCF) |  |  |
| google_profiler | [GoogleProfilerCF](#gitlab-agent-agentcfg-GoogleProfilerCF) |  |  |






<a name="gitlab-agent-agentcfg-RemoteDevelopmentCF"></a>

### RemoteDevelopmentCF
RemoteDevelopmentCF represents configurations for Workspaces for agentk.
Only the `enabled` field is used by the agentk.
Remaining fields are used in Rails to drive the workspace behaviour.
Note that we use integers instead of duration fields for time values, to match types stored in Rails.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| enabled | [bool](#bool) |  |  |
| dns_zone | [string](#string) |  |  |
| gitlab_workspaces_proxy | [GitLabWorkspacesProxy](#gitlab-agent-agentcfg-GitLabWorkspacesProxy) |  |  |
| network_policy | [WorkspaceNetworkPolicy](#gitlab-agent-agentcfg-WorkspaceNetworkPolicy) |  |  |
| default_resources_per_workspace_container | [ResourceRequirements](#gitlab-agent-agentcfg-ResourceRequirements) |  |  |
| max_resources_per_workspace | [ResourceRequirements](#gitlab-agent-agentcfg-ResourceRequirements) |  |  |
| workspaces_quota | [int32](#int32) | optional |  |
| workspaces_per_user_quota | [int32](#int32) | optional |  |
| image_pull_secrets | [WorkspaceImagePullSecret](#gitlab-agent-agentcfg-WorkspaceImagePullSecret) | repeated |  |
| annotations | [RemoteDevelopmentCF.AnnotationsEntry](#gitlab-agent-agentcfg-RemoteDevelopmentCF-AnnotationsEntry) | repeated |  |
| labels | [RemoteDevelopmentCF.LabelsEntry](#gitlab-agent-agentcfg-RemoteDevelopmentCF-LabelsEntry) | repeated |  |
| allow_privilege_escalation | [bool](#bool) |  |  |
| use_kubernetes_user_namespaces | [bool](#bool) |  |  |
| default_runtime_class | [string](#string) |  |  |
| max_active_hours_before_stop | [int32](#int32) | optional |  |
| max_stopped_hours_before_termination | [int32](#int32) | optional |  |
| shared_namespace | [string](#string) | optional |  |






<a name="gitlab-agent-agentcfg-RemoteDevelopmentCF-AnnotationsEntry"></a>

### RemoteDevelopmentCF.AnnotationsEntry



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [string](#string) |  |  |
| value | [string](#string) |  |  |






<a name="gitlab-agent-agentcfg-RemoteDevelopmentCF-LabelsEntry"></a>

### RemoteDevelopmentCF.LabelsEntry



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [string](#string) |  |  |
| value | [string](#string) |  |  |






<a name="gitlab-agent-agentcfg-Resource"></a>

### Resource



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| cpu | [string](#string) |  |  |
| memory | [string](#string) |  |  |
| ephemeral_storage | [string](#string) |  |  |






<a name="gitlab-agent-agentcfg-ResourceManagementCF"></a>

### ResourceManagementCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| enabled | [bool](#bool) |  |  |






<a name="gitlab-agent-agentcfg-ResourceRequirements"></a>

### ResourceRequirements



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| limits | [Resource](#gitlab-agent-agentcfg-Resource) |  |  |
| requests | [Resource](#gitlab-agent-agentcfg-Resource) |  |  |






<a name="gitlab-agent-agentcfg-TrivyK8sWrapperImage"></a>

### TrivyK8sWrapperImage



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| repository | [string](#string) |  |  |
| tag | [string](#string) |  |  |






<a name="gitlab-agent-agentcfg-UserAccessAsAgentCF"></a>

### UserAccessAsAgentCF







<a name="gitlab-agent-agentcfg-UserAccessAsCF"></a>

### UserAccessAsCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| agent | [UserAccessAsAgentCF](#gitlab-agent-agentcfg-UserAccessAsAgentCF) |  |  |
| user | [UserAccessAsUserCF](#gitlab-agent-agentcfg-UserAccessAsUserCF) |  |  |






<a name="gitlab-agent-agentcfg-UserAccessAsUserCF"></a>

### UserAccessAsUserCF







<a name="gitlab-agent-agentcfg-UserAccessCF"></a>

### UserAccessCF
https://gitlab.com/gitlab-org/cluster-integration/gitlab-agent/-/blob/master/doc/kubernetes_user_access.md


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| access_as | [UserAccessAsCF](#gitlab-agent-agentcfg-UserAccessAsCF) |  |  |
| projects | [UserAccessProjectCF](#gitlab-agent-agentcfg-UserAccessProjectCF) | repeated |  |
| groups | [UserAccessGroupCF](#gitlab-agent-agentcfg-UserAccessGroupCF) | repeated |  |
| instance | [UserAccessInstanceCF](#gitlab-agent-agentcfg-UserAccessInstanceCF) |  | UserAccessOrganizationCF organization = 5 [json_name = &#34;organization&#34;]; |






<a name="gitlab-agent-agentcfg-UserAccessGroupCF"></a>

### UserAccessGroupCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| id | [string](#string) |  |  |






<a name="gitlab-agent-agentcfg-UserAccessInstanceCF"></a>

### UserAccessInstanceCF







<a name="gitlab-agent-agentcfg-UserAccessProjectCF"></a>

### UserAccessProjectCF



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| id | [string](#string) |  |  |






<a name="gitlab-agent-agentcfg-VulnerabilityReport"></a>

### VulnerabilityReport



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| namespaces | [string](#string) | repeated |  |
| filters | [ContainerScanningFilter](#gitlab-agent-agentcfg-ContainerScanningFilter) | repeated |  |
| resource_types | [string](#string) | repeated | The Kubernetes Resource Types to inspect to identify Container Images to scan. Allowed Values: Pod, ReplicaSet, ReplicationController, StatefulSet, DaemonSet, CronJob, Job, Deployment |






<a name="gitlab-agent-agentcfg-WorkspaceImagePullSecret"></a>

### WorkspaceImagePullSecret
WorkspaceImagePullSecret represents an image pull secret and the namespace it is located


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| name | [string](#string) |  |  |
| namespace | [string](#string) |  |  |






<a name="gitlab-agent-agentcfg-WorkspaceNetworkPolicy"></a>

### WorkspaceNetworkPolicy
WorkspaceNetworkPolicy represents the firewall configuration for the remote development workspaces


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| enabled | [bool](#bool) | optional |  |
| egress | [WorkspaceNetworkPolicyEgress](#gitlab-agent-agentcfg-WorkspaceNetworkPolicyEgress) | repeated |  |






<a name="gitlab-agent-agentcfg-WorkspaceNetworkPolicyEgress"></a>

### WorkspaceNetworkPolicyEgress
WorkspaceNetworkPolicyEgress represent the firewall rules for the remote development workspaces


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| allow | [string](#string) |  |  |
| except | [string](#string) | repeated |  |





 


<a name="gitlab-agent-agentcfg-log_level_enum"></a>

### log_level_enum


| Name | Number | Description |
| ---- | ------ | ----------- |
| info | 0 | default value must be 0 |
| debug | 1 |  |
| warn | 2 |  |
| error | 3 |  |


 

 

 



## Scalar Value Types

| .proto Type | Notes | C++ | Java | Python | Go | C# | PHP | Ruby |
| ----------- | ----- | --- | ---- | ------ | -- | -- | --- | ---- |
| <a name="double" /> double |  | double | double | float | float64 | double | float | Float |
| <a name="float" /> float |  | float | float | float | float32 | float | float | Float |
| <a name="int32" /> int32 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint32 instead. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="int64" /> int64 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint64 instead. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="uint32" /> uint32 | Uses variable-length encoding. | uint32 | int | int/long | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="uint64" /> uint64 | Uses variable-length encoding. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum or Fixnum (as required) |
| <a name="sint32" /> sint32 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int32s. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sint64" /> sint64 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int64s. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="fixed32" /> fixed32 | Always four bytes. More efficient than uint32 if values are often greater than 2^28. | uint32 | int | int | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="fixed64" /> fixed64 | Always eight bytes. More efficient than uint64 if values are often greater than 2^56. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum |
| <a name="sfixed32" /> sfixed32 | Always four bytes. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sfixed64" /> sfixed64 | Always eight bytes. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="bool" /> bool |  | bool | boolean | boolean | bool | bool | boolean | TrueClass/FalseClass |
| <a name="string" /> string | A string must always contain UTF-8 encoded or 7-bit ASCII text. | string | String | str/unicode | string | string | string | String (UTF-8) |
| <a name="bytes" /> bytes | May contain any arbitrary sequence of bytes. | string | ByteString | str | []byte | ByteString | string | String (ASCII-8BIT) |

